<?php
# Start Browser Session
session_start();
# Include the Database
include 'database.php';
# Start Browser Session
include 'inc/routes/inc.routes.functions.php';
include 'inc/users/inc.users.functions.php';
include 'inc/settings/inc.settings.functions.php';
include 'emails.php';
// include 'phone.php'; # Need to upgrade Server to 7.2 php
include 'inc/notifications/inc.notifications.functions.php';
include 'inc/reviews/inc.reviews.functions.php';
include 'inc/faqs/inc.faqs.functions.php';
include 'inc/locations/inc.location.functions.php';
include 'inc/customers/inc.customer.functions.php';
include 'inc/inventoryitems/inc.inventoryitems.functions.php';

include 'inc/credits/inc.credits.functions.php';
include 'inc/delivery/inc.delivery.functions.php';
include 'inc/reports/inc.reports.functions.php';

ChangePickDateifPassed();
updateEstimateWithPayments();

## Mark estimate with payments as reservation
function updateEstimateWithPayments(){
    global $conn;
    $results = $conn->prepare("SELECT ORDERDETAILS.ID FROM ORDERDETAILS INNER JOIN PAYMENTS ON ORDERDETAILS.ID = PAYMENTS.ORDERDETAIL_ID WHERE ORDERDETAILS.STATUS = 'Estimate' OR ORDERDETAILS.STATUS = 'duplicate' OR ORDERDETAILS.STATUS = 'rejected' ");
    $results->execute();
    $ordersWithPaymentsPre = $results;

    while($ordersWithPayments = $ordersWithPaymentsPre->fetch(PDO::FETCH_ASSOC)){
        $id = $ordersWithPayments['ID'];
        $results = $conn->prepare("UPDATE `ORDERDETAILS` SET `STATUS`= 'Reservation' WHERE `ID` = :id");
        $results->bindParam(':id', $id);
        $results->execute();
    }

}


// Check if table Exists or Not
function tableExists($table) {
    global $conn;
    // Try a select statement against the table
    // Run it in try/catch in case PDO is in ERRMODE_EXCEPTION.
    try {
        $result = $conn->query("SELECT 1 FROM $table LIMIT 1");
    } catch (Exception $e) {
        // We got an exception == table not found
        return FALSE;
    }

    // Result is either boolean FALSE (no table found) or PDOStatement Object (table found)
    return $result !== FALSE;
}
# Below is a tiny function that will take any 10 digit number and convert it into the following phone format: 970-313-2428.
function phone_number_format($number) {
    // Allow only Digits, remove all other characters.
    $number = preg_replace("/[^\d]/","",$number);
    
    // get number length.
    $length = strlen($number);
    
    // if number = 10
    if($length == 10) {
    $number = preg_replace("/^1?(\d{3})(\d{3})(\d{4})$/", "$1-$2-$3", $number);
    }
    
    return $number;
    
}
function getUserIpAddr(){
    if(!empty($_SERVER['HTTP_CLIENT_IP'])){
        //ip from share internet
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    }elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
        //ip pass from proxy
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    }else{
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}

# Create Order Details
function createOrderDetails($organization_id, $customer_id, $delivery_address, $delivery_date, $event_start_time, $pickup_address, $pickup_date, $status,$type, $building_type, $setupNeeded, $suite, $allow_payment){ // 11 Varibles
    
    global $conn;

    $createddate = date("Y-m-d H:i:s");

    $results = $conn->prepare("INSERT INTO `ORDERDETAILS`(`ORGANIZATION_ID`, `CUSTOMER_ID`, `DELIVERY_ADDRESS`, `DELIVERY_DATE`,`EVENT_START_TIME`, `PICKUP_ADDRESS`, `PICKUP_DATE`, `STATUS`, `DATE_CREATED`,`TYPE`,`BUILDING_TYPE`,`SETUP`,`SUITE`, `ALLOW_PAYMENT` ) VALUES (:org_id, :customer_id,:delivery_address,:delivery_date,:event_start_time,:pickup_address, :pickup_date, :status, :createddate, :type, :building_type, :setup, :suite, :allow_payment)");

    $results->bindParam(':org_id', $organization_id);

    $results->bindParam(':customer_id', $customer_id);

    $results->bindParam(':delivery_address', $delivery_address);

    $results->bindParam(':delivery_date', $delivery_date);

    $results->bindParam(':event_start_time', $event_start_time);

    $results->bindParam(':pickup_address', $pickup_address);

    $results->bindParam(':pickup_date', $pickup_date);

    $results->bindParam(':status', $status);

    $results->bindParam(':createddate', $createddate);

    $results->bindParam(':type', $type);

    $results->bindParam(':building_type', $building_type);

    $results->bindParam(':setup', $setupNeeded);

    $results->bindParam(':suite', $suite);

    $results->bindParam(':allow_payment', $allow_payment);
    
    $results->execute();

    $last_id = $conn->lastInsertId();

    return $last_id;
}

# Create Order Items
function createOrderItems($orderdetails_id, $inventory_id, $quantity, $price){ // 4 Varibles
    
    global $conn;

    $results = $conn->prepare("INSERT INTO `ORDER_ITEMS`( `ORDERDETAILS_ID`, `INVENTORY_ID`, `QUANTITY`, `PRICE`) VALUES (:orderdetails_id, :inventory_id, :quantity, :price)");

    $results->bindParam(':orderdetails_id', $orderdetails_id);

    $results->bindParam(':inventory_id', $inventory_id);

    $results->bindParam(':quantity', $quantity);

    $results->bindParam(':price', $price);
  
    $results->execute();

    $last_id = $conn->lastInsertId();

    return $last_id;
}

function getProjectDetail($id){

    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `ID` = :id");
    $results->bindParam(':id', $id);
    $results->execute();
    return $results; 

}


function getProjectItems($order_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDER_ITEMS` WHERE `ORDERDETAILS_ID` = :id");
    $results->bindParam(':id', $order_id);
    $results->execute();
    return $results; 

}


function createaResavation($orderdetails_id, $paymentStatus){
    global $conn;
    $results = $conn->prepare("UPDATE `ORDERDETAILS` SET `STATUS`= 'Reservation', `PAYMENT` = :paymentStatus WHERE `ID` = :id");
    $results->bindParam(':paymentStatus', $paymentStatus);
    $results->bindParam(':id', $orderdetails_id);
    $results->execute();
    return $results; 
}

function createAPayment($organization_id, $orderdetails_id, $transaction_id, $amount, $type){
    global $conn;

    $createddate = date("Y-m-d H:i:s");

    $results = $conn->prepare("INSERT INTO `PAYMENTS`(`ORGANIZATION_ID`, `ORDERDETAIL_ID`, `TRANSACTION_ID`, `TYPE`, `AMOUNT`, `DATE`) VALUES (:organization_id, :orderdetails_id,:transaction_id, :type,:amount, :date)");

    $results->bindParam(':organization_id', $organization_id);

    $results->bindParam(':orderdetails_id', $orderdetails_id);

    $results->bindParam(':transaction_id', $transaction_id);

    $results->bindParam(':amount', $amount);

    $results->bindParam(':type', $type);

    $results->bindParam(':date', $createddate);
  
    $results->execute();

    $last_id = $conn->lastInsertId();

    return $last_id;
}

// Dashboard
function getpaymentsbyMonth($table, $month){
    global $conn;
    $lastdayofthemonth = date("Y-m-t", strtotime($month));
    $results = $conn->prepare("SELECT * FROM `".$table."` WHERE `DATE` >= '".$month."-01 00:00:00' AND `DATE` <= '".$lastdayofthemonth." 23:59:59' ORDER BY `DATE` DESC");
    $results->execute();
    $totalAmount;
    while ($getpaymentsbyMonth = $results->fetch(PDO::FETCH_ASSOC)) {
        $totalAmount = $totalAmount + $getpaymentsbyMonth['AMOUNT'];
    }
    $totalAmountafter = $totalAmount/100;

    return $totalAmountafter;
}

function gettotoalpaymentsbyMonth($table, $month){
    global $conn;
    $lastdayofthemonth = date("Y-m-t", strtotime($month));
    $results = $conn->prepare("SELECT * FROM `".$table."` WHERE `DATE` >= '".$month."-01 00:00:00' AND `DATE` <= '".$lastdayofthemonth." 23:59:59' ORDER BY `DATE` DESC");
    $results->execute();
    $totalAmount = 0;
    while ($getpaymentsbyMonth = $results->fetch(PDO::FETCH_ASSOC)) {
        $totalAmount = $totalAmount + 1;
    }

    return $totalAmount;
}
function getTotalAllTimePayments(){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `PAYMENTS` ");
    $results->execute();
    $totalAmount;
    while ($getTotalAllTimePayments = $results->fetch(PDO::FETCH_ASSOC)) {
        $totalAmount = $totalAmount + $getTotalAllTimePayments['AMOUNT'];
    }
    $totalAmountafter = $totalAmount/100;

    return $totalAmountafter;
}


function getordersbyMonth($table, $month){
    global $conn;
    $lastdayofthemonth = date("Y-m-t", strtotime($month));
    $results = $conn->prepare("SELECT * FROM `".$table."` WHERE `DELIVERY_DATE` >= '".$month."-01 00:00:00' AND `DELIVERY_DATE` <= '".$lastdayofthemonth." 23:59:59' AND `STATUS` = 'reservation' or `DELIVERY_DATE` >= '".$month."-01 00:00:00' AND `DELIVERY_DATE` <= '".$lastdayofthemonth." 23:59:59' AND `STATUS` = 'delivered' or `DELIVERY_DATE` >= '".$month."-01 00:00:00' AND `DELIVERY_DATE` <= '".$lastdayofthemonth." 23:59:59' AND `STATUS` = 'returned' or `DELIVERY_DATE` >= '".$month."-01 00:00:00' AND `DELIVERY_DATE` <= '".$lastdayofthemonth." 23:59:59' AND `STATUS` = 'completed' ORDER BY `DELIVERY_DATE` DESC");
    $results->execute();
    $totalAmount;
    while ($getordersbyMonth = $results->fetch(PDO::FETCH_ASSOC)) {
        $totalAmount = $totalAmount + 1;
    }

    return $totalAmount;
}
function getordersbyCustomer($customer_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `CUSTOMER_ID` = :customer_id ORDER BY `DELIVERY_DATE` DESC");
    $results->bindParam(':customer_id', $customer_id);
    $results->execute();
    return $results;
}

function getAllOrders($status){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `STATUS` = :status ORDER BY `DELIVERY_DATE` ASC");
    $results->bindParam(':status', $status);
    $results->execute();
    return $results; 

}

function getAllOrdersByPaymentStatus($status){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `PAYMENT` = :status AND `STATUS` != 'canceled' ORDER BY `DELIVERY_DATE` ASC");
    $results->bindParam(':status', $status);
    $results->execute();
    return $results; 

}

function getTotalNumberOfordersByStatus($status){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `STATUS` = :status");
    $results->bindParam(':status', $status);
    $results->execute();
    return $results->rowCount();
}

function getTotalNumberOforders(){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `STATUS` = 'delivered' OR `STATUS` = 'Reservation' OR `STATUS` = 'completed' OR `STATUS` = 'returned'" );
    $results->execute();
    return $results->rowCount();
}

function getProjectItemsDetails($inventory_id, $order_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDER_ITEMS` WHERE `INVENTORY_ID` = :inventory_id AND `ORDERDETAILS_ID` = :order_id");
    $results->bindParam(':inventory_id', $inventory_id);
    $results->bindParam(':order_id', $order_id);
    $results->execute();
    return $results->fetch(PDO::FETCH_ASSOC); 

}

function getallProjectItemsDetailsForInvemtoryItem($inventory_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDER_ITEMS` WHERE `INVENTORY_ID` = :inventory_id ");
    $results->bindParam(':inventory_id', $inventory_id);
    $results->execute();
    return $results; 

}


function getOrderPayments($orderdetail_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `PAYMENTS` WHERE `ORDERDETAIL_ID` = :orderdetail_id");
    $results->bindParam(':orderdetail_id', $orderdetail_id);
    $results->execute();
    return $results; 

}

// create Orders
function submitallItemsToOrder($category,$order_id ){
    $getInventoryItemsPre = getInventoryItems(1, $category); 
    while ($getInventoryItems = $getInventoryItemsPre->fetch(PDO::FETCH_ASSOC)){
        $item = $_POST['invetory-'.$getInventoryItems['ID']];
        if($item == 'Yes'){
            createOrderItems($order_id, $getInventoryItems['ID'] , 1, $getInventoryItems['DAY_RATE']);
        }elseif($item == 'No'){
            
        }elseif($item > 0){
            createOrderItems($order_id, $getInventoryItems['ID'] , $item, $getInventoryItems['DAY_RATE']);
        }
    }
}
# Categories Functions | Start
// Get all Categories for an organization
function getAllCategories($org_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `CATEGORIES` WHERE `ORGANIZATION_ID` = :org_id");
    $results->bindParam(':org_id', $org_id);
    $results->execute();
    return $results; 
}

// Update Orders
function updateOrderItems($order_Items_id, $quantity, $price){
    global $conn;
    $results = $conn->prepare("UPDATE `ORDER_ITEMS` SET `QUANTITY`= :quantity,`PRICE`= :price WHERE `ID` = :order_Items_id");
    $results->bindParam(':order_Items_id', $order_Items_id);
    $results->bindParam(':quantity', $quantity);
    $results->bindParam(':price', $price);
    $results->execute();
    return $results; 
}

function deleteOrderItems($order_Items_id){
    global $conn;
    $results = $conn->prepare("DELETE FROM `ORDER_ITEMS` WHERE `ID` = :order_Items_id");
    $results->bindParam(':order_Items_id', $order_Items_id);
    $results->execute();
    return $results; 
}

function getAllOrderItems($orderdetail_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDER_ITEMS` WHERE `ORDERDETAILS_ID` = :orderdetail_id");
    $results->bindParam(':orderdetail_id', $orderdetail_id);
    $results->execute();
    return $results; 
}

function checkIfUpdateOrderItemsIsNeeded($orderdetails_id, $org_id){
    $getAllOrderItemsPreSetup = getAllOrderItems($orderdetails_id);
    $getAllCategoriesPre = getAllCategories($org_id);
    // Loop through all Categories
    while ($getAllCategories = $getAllCategoriesPre->fetch(PDO::FETCH_ASSOC)){
        $category = $getAllCategories['ID'];
        $getInventoryItemsPre = getInventoryItems(1, $category); 
        //  Loop through all inventory items in a Category
        while ($getInventoryItems = $getInventoryItemsPre->fetch(PDO::FETCH_ASSOC)){
            
            // Varibles
            $inventory_id = $getInventoryItems['ID'];
            $quantity = $_POST['invetory-'.$getInventoryItems['ID']];
            $price = $_POST['invetory-price-'.$getInventoryItems['ID']];

            $getProjectItemsDetails = getProjectItemsDetails($inventory_id, $orderdetails_id);
            // If quantity greater than zero
            if($quantity > 0){
                // Loop through All Order Items already in database
                if($inventory_id == $getProjectItemsDetails['INVENTORY_ID']){
                    updateOrderItems($getProjectItemsDetails['ID'], $quantity, $price);
                }else{
                    createOrderItems($orderdetails_id, $inventory_id, $quantity, $price);
                }
            }else{
                if($inventory_id == $getProjectItemsDetails['INVENTORY_ID']){
                    //  If order item is already in database delete items that have 0 quantity 
                    deleteOrderItems($getProjectItemsDetails['ID']);
                } // While Loop #3
            } // Else
        } // While Loop #2
    } // While Loop #1
}
function updateOrderDetial($orderdetail_id, $daddress, $ddate, $dtimestart, $dtimeend, $estarttime, $pdate, $ptimestart, $ptimeend, $type, $building_type, $setup, $discount, $setupfee, $status, $payment, $deliveryoption, $assignment, $daybeforedelivery, $samedaypickup, $suite, $allow_payment, $deposit_payment){
    global $conn;
    $results = $conn->prepare("UPDATE `ORDERDETAILS` SET `DELIVERY_ADDRESS`= :daddress,`DELIVERY_DATE`= :ddate,`DELIVERY_TIME_START`= :dtimestart,`DELIVERY_TIME_END`= :dtimeend,`EVENT_START_TIME`= :estarttime,`PICKUP_DATE`= :pdate,`PICKUP_TIME_START`= :ptimestart,`PICKUP_TIME_END`= :ptimeend,`TYPE`=:type,`BUILDING_TYPE`=:building_type,`SETUP`=:setup,`DISCOUNT`=:discount, `SETUPFEE`=:setupfee, `STATUS`=:status, `PAYMENT`=:payment, `DELIVERY_OPTION`=:delivery_option, `ASSIGNMENT`=:assignment, `DAY_BEFORE_DELIVERY`=:daybeforedelivery, `SAME_DAY_PICKUP`=:samedaypickup, `SUITE`=:suite , `ALLOW_PAYMENT`=:allow_payment, `DEPOSIT_PAYMENT`= :deposit_payment  WHERE `ID` = :orderdetail_id");
    $results->bindParam(':orderdetail_id', $orderdetail_id);
    $results->bindParam(':daddress', $daddress);
    $results->bindParam(':ddate', $ddate);
    $results->bindParam(':dtimestart', $dtimestart);
    $results->bindParam(':dtimeend', $dtimeend);
    $results->bindParam(':estarttime', $estarttime);
    $results->bindParam(':pdate', $pdate);
    $results->bindParam(':ptimestart', $ptimestart);
    $results->bindParam(':ptimeend', $ptimeend);
    $results->bindParam(':type', $type);
    $results->bindParam(':building_type', $building_type);
    $results->bindParam(':setup', $setup);
    $results->bindParam(':setupfee', $setupfee);
    $results->bindParam(':discount', $discount);
    $results->bindParam(':status', $status);
    $results->bindParam(':payment', $payment);
    $results->bindParam(':delivery_option', $deliveryoption);
    $results->bindParam(':assignment', $assignment);
    $results->bindParam(':daybeforedelivery', $daybeforedelivery);
    $results->bindParam(':samedaypickup', $samedaypickup);
    $results->bindParam(':suite', $suite);
    $results->bindParam(':allow_payment', $allow_payment);
    $results->bindParam(':deposit_payment', $deposit_payment);
    $results->execute();
    return $results;
}
// Update total miles
function updateDeliveryMilesTotal($orderdetail_id, $miles){
    global $conn;
    $results = $conn->prepare("UPDATE `ORDERDETAILS` SET `DELIVERY_MILES` = :miles WHERE `ID` = :orderdetail_id");
    $results->bindParam(':orderdetail_id', $orderdetail_id);
    $results->bindParam(':miles', $miles);
    $results->execute();
    return $results;
}
// Get Delivery Address
function getDeliveryAddress($orderdetail_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `ID` = :id");
    $results->bindParam(':id', $orderdetail_id);
    $results->execute();
    $address = $results->fetch(PDO::FETCH_ASSOC);
    return $address['DELIVERY_ADDRESS'];
}
// Update Delivery Address Lat
function UpdateDeliveryAddressLat($orderdetail_id, $lat){
    global $conn;
    $results = $conn->prepare("UPDATE
    `ORDERDETAILS`
SET
    `DELIVERY_ADDRESS_LAT` = :lat
WHERE
    `ID` = :id");
    $results->bindParam(':id', $orderdetail_id);
    $results->bindParam(':lat', $lat);
    $results->execute();
    return $results;
}
// Update Delivery Address Log
function UpdateDeliveryAddressLog($orderdetail_id, $log){
    global $conn;
    $results = $conn->prepare("UPDATE  `ORDERDETAILS`
    SET
        `DELIVERY_ADDRESS_LOG` = :dlog
    WHERE
        `ID` = :id");
    $results->bindParam(':dlog', $log);
    $results->bindParam(':id', $orderdetail_id);
    $results->execute();
    return $results;
}

// Get Delivery Address Miles
function getDeliveryMiles($orderdetail_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `ID` = :id");
    $results->bindParam(':id', $orderdetail_id);
    $results->execute();
    $miles = $results->fetch(PDO::FETCH_ASSOC);
    return $miles['DELIVERY_MILES'];
}
// Change Delivery Miles if Address Changes
function IfAddressChanges($orderdetail_id,$delivery_address){
    // If new address is the same as old address do nothing
    if(getDeliveryAddress($orderdetail_id)== $delivery_address){
        exit;
    }else{// If new address is not the same as old address update miles
        updateDeliveryMilesTotal($orderdetail_id, getDeliveryMilesTotal($delivery_address, 1));
    }  
}

function getOrderTotalCost($orderdetail_id){
    $getProjectDetailPre = getProjectDetail($orderdetail_id);
    $getProjectDetail = $getProjectDetailPre->fetch(PDO::FETCH_ASSOC);
    $getCustomerDetailPre = getCustomerDetail($getProjectDetail['CUSTOMER_ID']);
    $getCustomerDetail = $getCustomerDetailPre->fetch(PDO::FETCH_ASSOC);
    $settings = getSettings(1);
    $subtotal = 0;
    $discount = $getProjectDetail['DISCOUNT'];
    if($getProjectDetail['DELIVERY_OPTION']=='delivery'){

        $getDeliveryMiles = getDeliveryMiles($orderdetail_id);

        // Get Mileges
        if(isset($getDeliveryMiles)){
            $deliverMiles = $getDeliveryMiles;
        }else{
            $deliverMiles = getDeliveryMilesTotal($getProjectDetail['DELIVERY_ADDRESS'], $getProjectDetail['ORGANIZATION_ID']);
            updateDeliveryMilesTotal($getProjectDetail['ID'], number_format($deliverMiles,2));
        }

        if($getProjectDetail['ID'] > 10905){
            if(number_format($deliverMiles, 2) >= 199){
                $pricepermile = 10.80;
            }elseif(number_format($deliverMiles, 2) >= 99){
                $pricepermile = 6.00;
            }elseif(number_format($deliverMiles, 2) >= 89){
                $pricepermile = 4.25;
            }elseif(number_format($deliverMiles, 2) >= 69){
                $pricepermile = 3.75;
            }elseif(number_format($deliverMiles, 2) >= 59){
                $pricepermile = 3.25;
            }elseif(number_format($deliverMiles, 2) >= 49){
                $pricepermile = 2.75;
            }elseif(number_format($deliverMiles, 2) >= 39){
                $pricepermile = 2.55;
            }elseif(number_format($deliverMiles, 2) >= 30){
                $pricepermile = 2.25;
            }elseif(number_format($deliverMiles, 2) >= 15){
                $pricepermile = 1.90;
            }else{
                $pricepermile = 1.75;
            }
        }elseif($getProjectDetail['ID'] > 1348){
            if(number_format($deliverMiles, 2) >= 199){
                $pricepermile = 3.80;
            }elseif(number_format($deliverMiles, 2) >= 99){
                $pricepermile = 2.80;
            }elseif(number_format($deliverMiles, 2) >= 50){
                $pricepermile = 2.10;
            }else{
                $pricepermile = 1.90;
            }
        }else{
            if(number_format($deliverMiles, 2) >= 199){
                $pricepermile = 3.80;
            }elseif(number_format($deliverMiles, 2) >= 99){
                $pricepermile = 2.80;
            }elseif(number_format($deliverMiles, 2) >= 50){
                $pricepermile = 2.10;
            }else{
                $pricepermile = 1.40;
            }
        }
        // Total Delivery
        if($getProjectDetail['ID'] > 10905){  
            if(bcmul(number_format($deliveryMiles, 2),number_format($pricepermile,2), 2) < 55){
                $deliveryTotal = 55.00;
            }else{
                $deliveryTotal = bcmul(number_format($deliveryMiles, 2),number_format($pricepermile,2), 2);
            }
        }elseif($getProjectDetail['ID'] > 1348){  
            if(bcmul(number_format($deliveryMiles, 2),number_format($pricepermile,2), 2) < 25){
                $deliveryTotal = 25.00;
            }else{
                $deliveryTotal = bcmul(number_format($deliveryMiles, 2),number_format($pricepermile,2), 2);
            }
        }else{
            $deliveryTotal = bcmul(number_format($deliveryMiles, 2),number_format($pricepermile,2), 2);
        }
    }else{
        $deliveryTotal = 0;
    }
    // Fee Section Start
    $fees = 0;
    if($getProjectDetail['DAY_BEFORE_DELIVERY'] > 0){
        $fees = $fees + $getProjectDetail['DAY_BEFORE_DELIVERY'];
    }
    if($getProjectDetail['SAME_DAY_PICKUP'] > 0){
        $fees = $fees + $getProjectDetail['SAME_DAY_PICKUP'];
    }
    if($getProjectDetail['BUILDING_TYPE'] == "Apartment"){
        $fees = $fees + $settings['APARTMENT_FEE'];
    }
    if($getCustomerDetail['SETUP'] == 'yes'){
        $fees = $fees + $getCustomerDetail['SETUPFEE'];
    }
    // Fee Section End

    // Get A All Order Items Start
    $getAllOrderItemsPre = getAllOrderItems($orderdetail_id);

    while($getAllOrderItems = $getAllOrderItemsPre->fetch(PDO::FETCH_ASSOC)){
        
        $itemCost = $getAllOrderItems['PRICE'] * $getAllOrderItems['QUANTITY'];
        $subtotal = $subtotal + $itemCost;
    }
    // Get A All Order Items End

    // Tax Section Start
    if($getCustomerDetail['TAX_EXEMPT'] == 'yes'){
        $salesTax = 0;
    }else{
        $salesTax = $subtotal * $settings['SALE_TAX_RATE']/100;
    }
    // Tax Section End
    
?><script>console.log("<?php echo $subtotal.' + '.$salesTax.' + '.$deliveryTotal.' + '.$fees.' - '.$discount;?>");</script><?php
    $total = $subtotal + $salesTax + $deliveryTotal + $fees + $getProjectDetail['SETUPFEE']  - $discount;

    return number_format($total,2);
}

# Setting Function
function ChangeOrderStatusByPassDate(){
    global $conn;
    $results = $conn->prepare("UPDATE
        `ORDERDETAILS`
    SET
        `STATUS` = 'Rejected'
    WHERE
        `DELIVERY_DATE` < CURRENT_DATE AND `STATUS` = 'Estimate'
    ");
    $results->execute();
    return $results; 
}

function getAllTotalNumberOfPaidorders(){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `STATUS` = 'reservation' or `STATUS` = 'delivered' or `STATUS` = 'returned' or `STATUS` = 'completed'");
    $results->execute();
    return $results->rowCount();

}

function getAllTotalNumberOforders(){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS`");
    $results->execute();
    return $results->rowCount();

}

function listAllPaymentforOrder($orderdetail_id){
    global $conn;

    $results = $conn->prepare("SELECT * FROM `PAYMENTS` WHERE `ORDERDETAIL_ID` = :orderdetail_id ORDER BY `DATE` DESC");

    $results->bindParam(':orderdetail_id', $orderdetail_id);
  
    $results->execute();

    return $results;
}

function numAllPaymentforOrder($orderdetail_id){
    global $conn;

    $results = $conn->prepare("SELECT * FROM `PAYMENTS` WHERE `ORDERDETAIL_ID` = :orderdetail_id ORDER BY `DATE` DESC");

    $results->bindParam(':orderdetail_id', $orderdetail_id);
  
    $results->execute();

    return $results->rowCount();
}

function numAllPayment(){
    global $conn;

    $results = $conn->prepare("SELECT * FROM `PAYMENTS` ORDER BY `DATE` DESC");
  
    $results->execute();

    return $results->rowCount();
}

function AllPayment(){
    global $conn;

    $results = $conn->prepare("SELECT * FROM `PAYMENTS` ORDER BY `DATE` DESC");
  
    $results->execute();

    return $results;
}
# Determine if the day is on a saturday
function isSaturday($date) {
    $day = date('N', strtotime($date));
     if( $day == 6){
        return true;
     }else{
        return false;
     }
     
}

function isFriday($date) {
    $day = date('N', strtotime($date));
     if( $day == 5){
        return true;
     }else{
        return false;
     }
     
}
# Setting Function
function ChangePickDateifPassed(){
    global $conn;
    $results = $conn->prepare("UPDATE
        `ORDERDETAILS`
    SET
        `PICKUP_DATE` = CURRENT_DATE
    WHERE
        `PICKUP_DATE` < CURRENT_DATE AND `STATUS` = 'delivered'
    ");
    $results->execute();
    return $results; 
}
### Security ###
function logHoneyPot($ip){
    global $conn;

    $date = date("Y-m-d H:i:s");

    $results = $conn->prepare("INSERT INTO `HONEYPOT`(`IP`, `DATE`) VALUES (:ip,:date)");

    $results->bindParam(':ip', $ip);

    $results->bindParam(':date', $date);

    $results->execute();

    $last_id = $conn->lastInsertId();

    return $last_id;

}