<?php

// Dashboard Route Setup
if(CheckIfPathRouteIsInTheDB('credits')){
    createRoute('credits', 'modulus/inc/credits/views/dashboard/credit.php', 'dashboard');
}
if(CheckIfPathRouteIsInTheDB('createcredit')){
    createRoute('createcredit', 'modulus/inc/credits/views/dashboard/editcredit.php', 'dashboard');
}
// Create table if Not Created
if(tableExists('CREDITS') == false){
    createCreditsTable();
}

if(tableExists('CREDITSASSIGNMENTS') == false){
    createCreditsAssignmentTable();
}

// Create CREDITS table in Database
function createCreditsTable(){
    global $conn;
    $sql="  CREATE TABLE `CREDITS` (
            `ID` int(255) NOT NULL,
            `CUSTOMER_ID` int(255) NOT NULL,
            `REASON` varchar(10000) NULL,
            `AMOUNT` int(255) NOT NULL,
            `CREATED_DATE` date NOT NULL,
            `STATUS` varchar(255) NOT NULL
            ) ENGINE=MyISAM DEFAULT CHARSET=latin1;

            ALTER TABLE `CREDITS`
                ADD PRIMARY KEY (`ID`);

            ALTER TABLE `CREDITS`
                MODIFY `ID` int(255) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
            COMMIT;
    ";
    $results = $conn->prepare($sql);
    $results->execute();
}
// Create CREDITSASSIGNMENTS table in Database
function createCreditsAssignmentTable(){
    global $conn;
    $sql="  CREATE TABLE `CREDITSASSIGNMENTS` (
            `ID` int(255) NOT NULL,
            `ORDER_ID` int(255) NOT NULL,
            `CUSTOMER_ID` int(255) NOT NULL,
            `AMOUNT` float NOT NULL,
            `CREATED_DATE` date NOT NULL
            ) ENGINE=MyISAM DEFAULT CHARSET=latin1;

            ALTER TABLE `CREDITSASSIGNMENTS`
                ADD PRIMARY KEY (`ID`);

            ALTER TABLE `CREDITSASSIGNMENTS`
                MODIFY `ID` int(255) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
            COMMIT;

    ";
    $results = $conn->prepare($sql);
    $results->execute();
}
// Get all the credits given 
function getAllCreditItems(){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `CREDITS` ");
    $results->execute();
    return $results; 
}

// Get one credits given by credit id
function getACreditItems($credit_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `CREDITS` WHERE `ID` = :id");
    $results->bindParam(':id', $note_id);
    $results->execute();
    return $results; 
}
// Get all credits given to customer
function getAllCreditItemsForCustomer($customer_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `CREDITS` WHERE `CUSTOMER_ID` = :id");
    $results->bindParam(':id', $customer_id);
    $results->execute();
    return $results; 
}
// Get Total Credit Amount by Customers
function gettotalCreditByCustomer($customer_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `CREDITS` WHERE `CUSTOMER_ID` = :id");
    $results->bindParam(':id', $customer_id);
    $results->execute();
    $totalCredits;
    while ($credits = $results->fetch(PDO::FETCH_ASSOC)) {
        $totalCredits = $totalCredits + $credits['AMOUNT'];
    }

    return $totalCredits; 
}
//  Get total credit amount used by customers
function gettotalCreditUsedByCustomer($customer_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `CREDITSASSIGNMENTS` WHERE `CUSTOMER_ID` = :id");
    $results->bindParam(':id', $customer_id);
    $results->execute();
    $totalCredits;
    while ($credits = $results->fetch(PDO::FETCH_ASSOC)) {
        $totalCredits = $totalCredits + $credits['AMOUNT'];
    }

    return $totalCredits; 
}
// Get total amount of credit added to order
function gettotalCreditUsedByOrder($order_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `CREDITSASSIGNMENTS` WHERE `ORDER_ID` = :id");
    $results->bindParam(':id', $order_id);
    $results->execute();
    $totalCredits;
    while ($credits = $results->fetch(PDO::FETCH_ASSOC)) {
        $totalCredits = $totalCredits + $credits['AMOUNT'];
    }

    return $totalCredits; 
}

function createNewCredit($customer_id, $reason, $amount, $date, $status){
    global $conn;
    $results = $conn->prepare("INSERT INTO `CREDITS`( `CUSTOMER_ID`, `REASON`, `AMOUNT`, `CREATED_DATE`, `STATUS`) VALUES (:customer_id,:reason,:amount,:created_date,:status)");
    $results->bindParam(':customer_id', $customer_id);
    $results->bindParam(':reason', $reason);
    $results->bindParam(':amount', $amount);
    $results->bindParam(':created_date', $date);
    $results->bindParam(':status', $status);
    $results->execute();
    $last_id = $conn->lastInsertId();
    return $last_id; 
}
function createNewCreditAssignment( $amount, $order_id ,$customer_id){
    global $conn;
    $date = date("Y-m-d H:i:s");
    $results = $conn->prepare("INSERT INTO `CREDITSASSIGNMENTS`( `ORDER_ID`, `AMOUNT`, `CUSTOMER_ID`, `CREATED_DATE`) VALUES (:order_id,:amount,:customer_id, :created_date)");
    $results->bindParam(':order_id', $order_id);
    $results->bindParam(':customer_id', $customer_id);
    $results->bindParam(':amount', $amount);
    $results->bindParam(':created_date', $date);
    $results->execute();
    $last_id = $conn->lastInsertId();
    return $last_id; 
}
