<?php
### Customers Module Setup Start ####
// Dashboard Route Setup
if(CheckIfPathRouteIsInTheDB('editcustomer')){
    createRoute('editcustomer', 'modulus/inc/customers/views/dashboard/editcustomer.php', 'dashboard');
}
if(CheckIfPathRouteIsInTheDB('createcustomer')){
    createRoute('createcustomer', 'modulus/inc/customers/views/dashboard/createcustomer.php', 'dashboard');
}
// Create table if Not Created
if(tableExists('CUSTOMERS')== false){
    createCustomersTable();
}

// Create Customers table in Database
function createCustomersTable(){
    global $conn;
    $sql="  CREATE TABLE `CUSTOMERS` (
            `ID` int(255) NOT NULL,
            `ORGANIZATION_ID` int(255) NOT NULL,
            `NAME` varchar(255) NOT NULL,
            `EMAIL` varchar(255) NOT NULL,
            `PHONE` varchar(255) NOT NULL,
            `PLANNER` varchar(255) DEFAULT NULL,
            `CREATEDDATE` varchar(255) NOT NULL,
            `SOURCE` varchar(255) DEFAULT NULL,
            `STATUS` varchar(255) NOT NULL,
            `COMPANY` varchar(255) NOT NULL,
            `IP` varchar(255) DEFAULT NULL,
            `TAX_EXEMPT` varchar(11) DEFAULT NULL
            )   ENGINE=MyISAM DEFAULT CHARSET=latin1;
        
            ALTER TABLE `CUSTOMERS`
                ADD PRIMARY KEY (`ID`);
            
            ALTER TABLE `CUSTOMERS`
                MODIFY `ID` int(255) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
            COMMIT;
        ";
     $results = $conn->prepare($sql);
     $results->execute();
}
### Customers Module Setup End ####

### Function Start ###
# Create a Customer
function createACustomer($organization_id, $name, $email, $phone, $status, $company, $ip, $source, $planner,$taxexempt){ // 10 Varibles
    global $conn;
    $createddate = date("Y-m-d H:i:s");
    $results = $conn->prepare("INSERT INTO `CUSTOMERS`(`ORGANIZATION_ID`, `NAME`, `EMAIL`, `PHONE`,`CREATEDDATE`,`SOURCE`,`STATUS`,`COMPANY`,`IP`, `PLANNER`,`TAX_EXEMPT`) VALUES (:organization_id, :name, :email, :phone, :createddate, :source, :status, :company, :ip, :planner,:taxexempt)");
    $results->bindParam(':organization_id', $organization_id);
    $results->bindParam(':name', $name);
    $results->bindParam(':email', $email);
    $results->bindParam(':phone', $phone);
    $results->bindParam(':createddate', $createddate);
    $results->bindParam(':status', $status);
    $results->bindParam(':source', $source);
    $results->bindParam(':company',$company);
    $results->bindParam(':ip', $ip);
    $results->bindParam(':planner', $planner);
    $results->bindParam(':taxexempt', $taxexempt);
    $results->execute();
    $last_id = $conn->lastInsertId();

    return $last_id;
}
# Update Customer
function updateCustomerDetails($customer_id,$name,$company,$email,$phone,$planner,$status,$source,$taxexempt){ // 9 Varibles
    global $conn;
    $results = $conn->prepare("UPDATE `CUSTOMERS` SET `NAME`=:name,`EMAIL`=:email,`PHONE`=:phone,`PLANNER`=:planner,`SOURCE`=:source,`STATUS`=:status,`COMPANY`=:company,`TAX_EXEMPT`=:taxexempt WHERE `ID` = :customer_id");
    $results->bindParam(':customer_id', $customer_id);
    $results->bindParam(':name', $name);
    $results->bindParam(':company', $company);
    $results->bindParam(':email', $email);
    $results->bindParam(':phone', $phone);
    $results->bindParam(':planner', $planner);
    $results->bindParam(':status', $status);
    $results->bindParam(':source', $source);
    $results->bindParam(':taxexempt', $taxexempt);
    $results->execute();
    return $results;
}

function getCustomerDetail($user_id){ // 1 Varibles
    global $conn;
    $results = $conn->prepare("SELECT * FROM `CUSTOMERS` WHERE `ID` = :id");
    $results->bindParam(':id', $user_id);
    $results->execute();
    return $results; 
}

function getAllCustomers($org_id){ // 1 Varibles
    global $conn;
    $results = $conn->prepare("SELECT * FROM `CUSTOMERS` WHERE `ORGANIZATION_ID` = :org_id ORDER BY `NAME` ASC ");
    $results->bindParam(':org_id', $org_id);
    $results->execute();
    return $results; 
}

function getCustomerDetailsByPhoneNumber($phone){ // 1 Varibles
    global $conn;
    $results = $conn->prepare("SELECT * FROM `CUSTOMERS` WHERE `PHONE` = :phone");
    $results->bindParam(':phone', $phone);
    $results->execute();
    return $results->fetch(PDO::FETCH_ASSOC); 
}


