<?php
### Inventory  Module Setup Start ####
// Dashboard Route Setup
if(CheckIfPathRouteIsInTheDB('editinventory')){
    createRoute('editinventory', 'modulus/inc/inventoryitems/views/dashboard/editinventory.php', 'dashboard');
}
if(CheckIfPathRouteIsInTheDB('createinventory')){
    createRoute('createinventory', 'modulus/inc/inventoryitems/views/dashboard/createinventory.php', 'dashboard');
}
// Create table if Not Created
if(tableExists('INVENTORY')== false){
    createInventoryTable();
}

// Create Customers table in Database
function createInventoryTable(){
    global $conn;
    $sql="  CREATE TABLE `INVENTORY` (
            `ID` int(255) NOT NULL,
            `ORGANIZATIONS_ID` int(255) NOT NULL,
            `NAME` varchar(255) NOT NULL,
            `DAY_RATE` decimal(60,2) NOT NULL,
            `DESCRIPTION` varchar(1000) NOT NULL,
            `QUANTITY` int(255) NOT NULL,
            `WHOLESALE_PRICE` varchar(255) NOT NULL,
            `CREATEDDATE` varchar(255) NOT NULL,
            `STATUS` varchar(255) NOT NULL,
            `IMG` varchar(510) DEFAULT NULL,
            `CATEGORY` varchar(255) DEFAULT NULL
            ) ENGINE=MyISAM DEFAULT CHARSET=latin1;

            ALTER TABLE `INVENTORY`
                ADD PRIMARY KEY (`ID`);
            COMMIT;

            ALTER TABLE `INVENTORY`
                MODIFY `ID` int(255) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
            COMMIT;

    ";
    $results = $conn->prepare($sql);
    $results->execute();
}
### Inventory Module Setup End ####

### Function Start Here ###
function createInventoryItem($org_id, $name, $day_rate, $description, $quantity, $wholesale_price, $status, $img, $category){
    global $conn;
    $createddate = date("Y-m-d H:i:s");
    $results = $conn->prepare("INSERT INTO `INVENTORY`(`ORGANIZATIONS_ID`, `NAME`, `DAY_RATE`, `DESCRIPTION`, `QUANTITY`, `WHOLESALE_PRICE`, `CREATEDDATE`, `STATUS`, `IMG`, `CATEGORY`) VALUES (:org_id,:name,:day_rate,:description,:quantity,:wholesale_price,:createddate,:status,:img,:category)");
    $results->bindParam(':org_id', $org_id);
    $results->bindParam(':name', $name);
    $results->bindParam(':day_rate', $day_rate);
    $results->bindParam(':description', $description);
    $results->bindParam(':quantity', $quantity);
    $results->bindParam(':wholesale_price', $wholesale_price);
    $results->bindParam(':createddate', $createddate);
    $results->bindParam(':status', $status);
    $results->bindParam(':img', $img);
    $results->bindParam(':category', $category);
    $results->execute();
    $last_id = $conn->lastInsertId();
    return $last_id;
}
function updateInventoryItem($item_id, $name, $day_rate, $description, $quantity, $wholesale_price, $status, $img, $category){
    global $conn;
    $results = $conn->prepare("UPDATE `INVENTORY` SET`ORGANIZATIONS_ID`= 1,`NAME`=:name,`DAY_RATE`= :day_rate,`DESCRIPTION`=:description,`QUANTITY`=:quantity,`WHOLESALE_PRICE`= :wholesale_price, `STATUS`=:status,`IMG`=:img,`CATEGORY`=:category WHERE `ID` = :item_id");
    $results->bindParam(':name', $name);
    $results->bindParam(':day_rate', $day_rate);
    $results->bindParam(':description', $description);
    $results->bindParam(':quantity', $quantity);
    $results->bindParam(':wholesale_price', $wholesale_price);
    $results->bindParam(':status', $status);
    $results->bindParam(':img', $img);
    $results->bindParam(':category', $category);
    $results->bindParam(':item_id', $item_id);
    $results->execute();
    return $results; 
}
function getInventoryItemDetails($id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `INVENTORY` WHERE `ID` = :id");
    $results->bindParam(':id', $id);
    $results->execute();
    return $results; 
}

function getInventoryItems($org_id, $category){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `INVENTORY` WHERE `ORGANIZATIONS_ID` = :org_id AND `CATEGORY` = :category ORDER BY `DAY_RATE` ASC");
    $results->bindParam(':org_id', $org_id);
    $results->bindParam(':category', $category);
    $results->execute();
    return $results; 
}

function getAllInventoryItems($org_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `INVENTORY` WHERE `ORGANIZATIONS_ID` = :org_id ORDER BY `DAY_RATE` ASC");
    $results->bindParam(':org_id', $org_id);
    $results->execute();
    return $results; 
}
### Function End Here ###