<?php
// Dashboard Route Setup
if(CheckIfPathRouteIsInTheDB('editlocation')){
    createRoute('editlocation', 'modulus/inc/locations/views/dashboard/editlocation.php', 'dashboard');
}
if(CheckIfPathRouteIsInTheDB('createlocation')){
    createRoute('createlocation', 'modulus/inc/locations/views/dashboard/createlocation.php', 'dashboard');
}
function getAllLocations($org_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `LOCATIONS` WHERE `ORGANIZATIONS_ID` = :org_id");
    $results->bindParam(':org_id', $org_id);
    $results->execute();
    return $results; 

}

function getALocationByID($id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `LOCATIONS` WHERE `ID` = :id");
    $results->bindParam(':id', $id);
    $results->execute();
    return $results; 

}

function createlocation($org_id, $address, $phone, $status){
    global $conn;
    $results = $conn->prepare("INSERT INTO `LOCATIONS`(`ORGANIZATIONS_ID`, `ADDRESS`, `PHONE`, `STATUS`) VALUES (:org_id, :address, :phone, :status)");
    $results->bindParam(':address', $address);
    $results->bindParam(':status', $status);
    $results->bindParam(':phone', $phone);
    $results->bindParam(':org_id', $org_id);
    $results->execute();
    $last_id = $conn->lastInsertId();

    return $last_id; 
}

function updatelocation($id, $address, $phone, $status){
    global $conn;
    $results = $conn->prepare("UPDATE `LOCATIONS` SET `ADDRESS`=:address ,`PHONE`= :phone ,`STATUS`= :status WHERE `ID` = :id");
    $results->bindParam(':address', $address);
    $results->bindParam(':status', $status);
    $results->bindParam(':phone', $phone);
    $results->bindParam(':id', $id);
    $results->execute();
    return $results; 
}

function getDeliveryMilesTotal($destination, $org_id){
    $destination =   str_replace(" ", "+", $destination) ;
    $settings = getSettings(1);
    $googleAPI = $settings['GOOGLE_API_KEY'];
    $getAllLocationsPre = getAllLocations($org_id);
    $deliveryMiles = 0;
    while($getAllLocations = $getAllLocationsPre->fetch(PDO::FETCH_ASSOC)){
        $office = str_replace(" ", "+", $getAllLocations['ADDRESS'] ) ;
        $link = "https://maps.googleapis.com/maps/api/distancematrix/json?units=imperial&origins=".$office."&destinations=".$destination."&mode=driving&sensor=false&key=".$settings['GOOGLE_API_KEY']."";
        $json = file_get_contents($link);
        $details = json_decode($json, TRUE);

        $miles = trim($details['rows'][0]['elements'][0]['distance']['text']," \mi.") ;

        if($deliveryMiles == 0 ){
            $deliveryMiles = $miles;
        }elseif($deliveryMiles > $miles ){
            $deliveryMiles = $miles;
        }else{

        }
    }

    return $deliveryMiles;
    
}