<?php

if(CheckIfPathRouteIsInTheDB('reports-monthly')){
    createRoute('reports-monthly', 'modulus/inc/reports/views/dashboard/reports-monthly.php', 'dashboard');
}
if(CheckIfPathRouteIsInTheDB('reports')){
    createRoute('reports', 'modulus/inc/reports/views/dashboard/reports.php', 'dashboard');
}
if(CheckIfPathRouteIsInTheDB('workers-reports')){
    createRoute('workers-reports', 'modulus/inc/reports/views/dashboard/employeereports.php', 'dashboard');
}

function getAllEstimateforThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday ORDER BY `ORDERDETAILS`.`DELIVERY_DATE` ASC");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    $results->execute();
    return $results; 

}

    function getAllOrdersforThisWeekStartingwith($monday){
        global $conn;
        $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `STATUS` = 'Reservation' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday OR `STATUS` = 'Completed' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday OR `STATUS` = 'Delivered' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday OR `STATUS` = 'pickuped' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday ORDER BY `ORDERDETAILS`.`DELIVERY_DATE` ASC");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    $results->execute();
    return $results; 

}

function getAllCustomerPickupOrdersforThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE 
    `STATUS` = 'Reservation' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND `DELIVERY_OPTION` = 'pickup' 
    OR `STATUS` = 'Completed' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND `DELIVERY_OPTION` = 'pickup' 
    OR `STATUS` = 'Delivered' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND `DELIVERY_OPTION` = 'pickup' 
    OR `STATUS` = 'pickuped' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND `DELIVERY_OPTION` = 'pickup' 
    ORDER BY `ORDERDETAILS`.`DELIVERY_DATE` ASC");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    $results->execute();
    return $results; 
}

function getAllDeliveryOrdersforThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `STATUS` = 'Reservation' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND `DELIVERY_OPTION` = 'delivery'  OR `STATUS` = 'Completed' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND `DELIVERY_OPTION` = 'delivery' OR `STATUS` = 'Delivered' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND `DELIVERY_OPTION` = 'delivery' ORDER BY `ORDERDETAILS`.`DELIVERY_DATE` ASC");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    $results->execute();
    return $results; 
}

function getCountAllOrdersforThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `STATUS` = 'Reservation' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday OR `STATUS` = 'Completed' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday OR `STATUS` = 'Delivered' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday OR `STATUS` = 'pickuped' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday ORDER BY `ORDERDETAILS`.`DELIVERY_DATE` ASC");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    $results->execute();
    return $results->rowCount(); 

}

function getWeeklyOrderAmount($monday){
    $total = 0.00;
    $orderspre = getAllOrdersforThisWeekStartingwith($monday);
    while ($orderDetails = $orderspre->fetch(PDO::FETCH_ASSOC)) {
        $orderCost = str_replace(",", "",getOrderTotalCost($orderDetails['ID']));
        $total = (float)$total + (float)$orderCost;
    }
    return $total;
}
function getWeeklyOrderDeliveryFeeAmount($monday){
    $totalDelFee = 0.00;
    $orderspre =  getAllDeliveryOrdersforThisWeekStartingwith($monday);
    while ($orderDetails = $orderspre->fetch(PDO::FETCH_ASSOC)) {
        $deliveryMiles = $orderDetails['DELIVERY_MILES'];

        if($orderDetails['ID'] > 2629){
            if(number_format($deliveryMiles, 2) >= 199){
                $pricepermile = 3.80;
            }elseif(number_format($deliveryMiles, 2) >= 99){
                $pricepermile = 2.80;
            }elseif(number_format($deliveryMiles, 2) >= 50){
                $pricepermile = 2.10;
            }else{
                $pricepermile = 1.90;
            }
            $deliveryCost = (float)$pricepermile * (float)$deliveryMiles;
            
            if($deliveryCost < 30){
                $deliveryCost = 30.00;
            }else{
                $deliveryCost = (float)$pricepermile * (float)$deliveryMiles;
            }
            if($orderDetails['BUILDING_TYPE'] == "Apartment"){
                 $apartmentFee = 15.00;
            }else{
                $apartmentFee = 0.00;
                
                }
            $totalDelFee = (float)$totalDelFee + (float)$deliveryCost + $orderDetails['DAY_BEFORE_DELIVERY'] + $orderDetails['SAME_DAY_PICKUP'] + $orderDetails['AFTER_HOURS_FEE'] + $orderDetails['SETUPFEE'] + $apartmentFee;

        }else{

            if(number_format($deliveryMiles, 2) >= 199){
                $pricepermile = 3.80;
            }elseif(number_format($deliveryMiles, 2) >= 99){
                $pricepermile = 2.80;
            }elseif(number_format($deliveryMiles, 2) >= 50){
                $pricepermile = 2.10;
            }else{
                $pricepermile = 1.40;
            }
            $deliveryCost = (float)$pricepermile * (float)$deliveryMiles;
            if($orderDetails['BUILDING_TYPE'] == "Apartment"){
                 $apartmentFee = 15.00;
            }else{
                $apartmentFee = 0.00;
            }
            $totalDelFee = (float)$totalDelFee + (float)$deliveryCost + $orderDetails['DAY_BEFORE_DELIVERY'] + $orderDetails['SAME_DAY_PICKUP'] + $orderDetails['AFTER_HOURS_FEE'] + $orderDetails['SETUPFEE'] + $apartmentFee;
        }
    }
    return $totalDelFee;
}
function getTheMondayForWeek($date){
    $day = date('N', strtotime($date));
    $dayToAdd = $day-1;
    $monday = date('Y-m-d', strtotime($date .'-'. $dayToAdd.' day'));
    return $monday;
}
function getTheSundayForWeek($monday){
    $day = date('N', strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday .' +6 day'));
    return $sunday;
}

function getQuantityByWeekendThatNotDelivery($thursday, $saturday, $inventory_id){
    global $conn;
    $results = $conn->prepare(
        "SELECT
            SUM(ORDER_ITEMS.QUANTITY)
        FROM
            ORDER_ITEMS
        INNER JOIN ORDERDETAILS ON ORDER_ITEMS.ORDERDETAILS_ID = ORDERDETAILS.ID
        WHERE
            ORDER_ITEMS.INVENTORY_ID = :inventory_id AND ORDERDETAILS.DELIVERY_DATE >= ':thursday' AND ORDERDETAILS.DELIVERY_DATE <= ':saturday' AND ORDERDETAILS.PICKUP_DATE >= ':saturday' AND ORDERDETAILS.STATUS = 'Reservation' AND ORDERDETAILS.STATUS = 'Delivered' AND ORDERDETAILS.STATUS = 'Completed'
        ");
    $results->bindParam(':thursday', $thursday);
    $results->bindParam(':saturday', $saturday);
    $results->bindParam(':inventory_id', $inventory_id);
    $results->execute();
    $quantity = $results->fetch(PDO::FETCH_NUM);
    return $quantity[0];
}
function getQuantityByWeekend($thursday, $saturday, $inventory_id){
    global $conn;
    $results = $conn->prepare(
        "SELECT
            SUM(ORDER_ITEMS.QUANTITY)
        FROM
            ORDER_ITEMS
        INNER JOIN ORDERDETAILS ON ORDER_ITEMS.ORDERDETAILS_ID = ORDERDETAILS.ID
        WHERE
            ORDER_ITEMS.INVENTORY_ID = :inventory_id AND ORDERDETAILS.DELIVERY_DATE >= :thursday AND ORDERDETAILS.DELIVERY_DATE <= :saturday AND ORDERDETAILS.PICKUP_DATE >= :saturday AND ORDERDETAILS.STATUS = 'Reservation' OR ORDER_ITEMS.INVENTORY_ID = :inventory_id AND ORDERDETAILS.DELIVERY_DATE >= :thursday AND ORDERDETAILS.DELIVERY_DATE <= :saturday AND ORDERDETAILS.PICKUP_DATE >= :saturday AND ORDERDETAILS.STATUS = 'Completed' OR ORDER_ITEMS.INVENTORY_ID = :inventory_id AND ORDERDETAILS.DELIVERY_DATE >= :thursday AND ORDERDETAILS.DELIVERY_DATE <= :saturday AND ORDERDETAILS.PICKUP_DATE >= :saturday AND ORDERDETAILS.STATUS = 'Delivered'
        ");
    $results->bindParam(':thursday', $thursday);
    $results->bindParam(':saturday', $saturday);
    $results->bindParam(':inventory_id', $inventory_id);
    $results->execute();
    $quantity = $results->fetch(PDO::FETCH_NUM);
    return $quantity[0];
}

function getAllOrdersWithPaymentStatusPartialforThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `STATUS` = 'Reservation' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday  AND `PAYMENT` = 'Partial' OR `STATUS` = 'Completed' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday  AND `PAYMENT` = 'Partial' OR `STATUS` = 'Delivered' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND `PAYMENT` = 'Partial' ORDER BY `ORDERDETAILS`.`DELIVERY_DATE` ASC");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    $results->execute();
    return $results; 

}
function gettotalLinenPaymentThisWeekStartingwith($monday, $category_id){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT
    sum(@amount := ORDER_ITEMS.PRICE * ORDER_ITEMS.QUANTITY)
    FROM
        `ORDER_ITEMS`
    INNER JOIN ORDERDETAILS ON ORDER_ITEMS.ORDERDETAILS_ID = ORDERDETAILS.ID
    INNER JOIN INVENTORY ON ORDER_ITEMS.INVENTORY_ID = INVENTORY.ID
    WHERE
    ORDERDETAILS.STATUS = 'Reservation' AND INVENTORY.CATEGORY = :category_id AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday 
    OR ORDERDETAILS.STATUS = 'Delivered' AND INVENTORY.CATEGORY = :category_id  AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday 
    OR ORDERDETAILS.STATUS = 'Completed' AND INVENTORY.CATEGORY = :category_id AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday
    OR ORDERDETAILS.STATUS = 'Pickedup' AND INVENTORY.CATEGORY = :category_id AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday ");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    $results->bindParam(':category_id', $category_id);
    $results->execute();
    $amount = $results->fetch(PDO::FETCH_NUM);

    return $amount[0]; 
}

function gettotalDamangeWaiverPaymentThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT
    sum(@amount := ORDER_ITEMS.PRICE * ORDER_ITEMS.QUANTITY* .10)
    FROM
        `ORDER_ITEMS`
    INNER JOIN ORDERDETAILS ON ORDER_ITEMS.ORDERDETAILS_ID = ORDERDETAILS.ID
    INNER JOIN INVENTORY ON ORDER_ITEMS.INVENTORY_ID = INVENTORY.ID
    WHERE
    ORDERDETAILS.STATUS = 'Reservation' AND ORDERDETAILS.ID > 3009 AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday 
    OR ORDERDETAILS.STATUS = 'Delivered' AND ORDERDETAILS.ID > 3009  AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday 
    OR ORDERDETAILS.STATUS = 'Completed' AND ORDERDETAILS.ID > 3009 AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday
    OR ORDERDETAILS.STATUS = 'Pickedup' AND ORDERDETAILS.ID > 3009 AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday ");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    $results->execute();
    $amount = $results->fetch(PDO::FETCH_NUM);

    return $amount[0]; 
}

function gettotalRentalAmountPaymentThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT
    sum(@amount := ORDER_ITEMS.PRICE * ORDER_ITEMS.QUANTITY )
    FROM
        `ORDER_ITEMS`
    INNER JOIN ORDERDETAILS ON ORDER_ITEMS.ORDERDETAILS_ID = ORDERDETAILS.ID
    INNER JOIN INVENTORY ON ORDER_ITEMS.INVENTORY_ID = INVENTORY.ID
    WHERE
    ORDERDETAILS.STATUS = 'Reservation'  AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday 
    OR ORDERDETAILS.STATUS = 'Delivered'  AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday 
    OR ORDERDETAILS.STATUS = 'Completed' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday
    OR ORDERDETAILS.STATUS = 'Pickedup' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday ");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    $results->execute();
    $amount = $results->fetch(PDO::FETCH_NUM);

    return $amount[0]; 
}

function getTotalCashInThisWeek($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT
        SUM(PAYMENTS.AMOUNT)
    FROM
        `PAYMENTS`
    WHERE
        PAYMENTS.DATE >= :monday AND PAYMENTS.DATE <= :sunday");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    $results->execute();
    $amount = $results->fetch(PDO::FETCH_NUM);

    return $amount[0]; 
}

function getAllOrdersByWeekAndStatus($monday, $status){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare('SELECT * FROM `ORDERDETAILS` WHERE `STATUS` = :status AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday ORDER BY `DELIVERY_DATE` ASC');
    $results->bindParam(":status", $status);
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    $results->execute();
    return $results; 

}

function gettotalSalesTaxThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT
    SUM(
        @amount := ORDER_ITEMS.PRICE * ORDER_ITEMS.QUANTITY * .0825
    )
    FROM
        `ORDER_ITEMS`
    INNER JOIN ORDERDETAILS ON ORDER_ITEMS.ORDERDETAILS_ID = ORDERDETAILS.ID
    INNER JOIN CUSTOMERS ON ORDERDETAILS.CUSTOMER_ID = CUSTOMERS.ID
    WHERE
    ORDERDETAILS.STATUS = 'Reservation' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND CUSTOMERS.TAX_EXEMPT = 'no'
    OR ORDERDETAILS.STATUS = 'Reservation' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND CUSTOMERS.TAX_EXEMPT IS NULL
    OR ORDERDETAILS.STATUS = 'Delivered' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND CUSTOMERS.TAX_EXEMPT = 'no'
    OR ORDERDETAILS.STATUS = 'Delivered' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND CUSTOMERS.TAX_EXEMPT IS NULL
    OR ORDERDETAILS.STATUS = 'Completed' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND CUSTOMERS.TAX_EXEMPT = 'no'
    OR ORDERDETAILS.STATUS = 'Completed' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND CUSTOMERS.TAX_EXEMPT IS NULL
    OR ORDERDETAILS.STATUS = 'Pickedup' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND CUSTOMERS.TAX_EXEMPT = 'no'
    OR ORDERDETAILS.STATUS = 'Pickedup' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday AND CUSTOMERS.TAX_EXEMPT IS NULL
    ");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    $results->execute();
    $amount = $results->fetch(PDO::FETCH_NUM);

    return $amount[0]; 
}


function getTotaldiscountInThisWeek($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT
        SUM(ORDERDETAILS.DISCOUNT)
    FROM
        `ORDERDETAILS`
        WHERE
    ORDERDETAILS.STATUS = 'Reservation'  AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday 
    OR ORDERDETAILS.STATUS = 'Delivered'  AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday 
    OR ORDERDETAILS.STATUS = 'Completed' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday
    OR ORDERDETAILS.STATUS = 'Pickedup' AND `DELIVERY_DATE` >= :monday AND `DELIVERY_DATE` <= :sunday ");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    $results->execute();
    $amount = $results->fetch(PDO::FETCH_NUM);

    return $amount[0]; 
}


function lifeTimeCustomerValueByCustomer($customerid){
    global $conn;
    $results = $conn->prepare("SELECT
    
    SUM(PAYMENTS.AMOUNT) / 100
    FROM
        `ORDERDETAILS`
    INNER JOIN `PAYMENTS` ON PAYMENTS.ORDERDETAIL_ID = ORDERDETAILS.ID
    WHERE
        ORDERDETAILS.CUSTOMER_ID = :customerid");
    $results->bindParam(':customerid', $customerid);
    $results->execute();
    $amount = $results->fetch(PDO::FETCH_NUM);

    return $amount[0]; 
}
function getAllReviewsforThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT * FROM `REVIEWS` WHERE `DATE` >= :monday AND `DATE` <= :sunday");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    
    $results->execute();
    return $results; 
}

function getAllCallorThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT * FROM `CALLS` WHERE `DATE` >= :monday AND `DATE` <= :sunday");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    
    $results->execute();
    return $results; 
}
function getAllNewQuoteforThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `DATE_CREATED` >= :monday AND `DATE_CREATED` <= :sunday");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    
    $results->execute();
    return $results; 
}
function getAllSignedContractsforThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT * FROM `CONTRACTS` WHERE `SIGNED_DATE` >= :monday AND `SIGNED_DATE` <= :sunday");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    
    $results->execute();
    return $results; 
}
function getAllPagesforThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT * FROM `PAGES` WHERE `DATE` >= :monday AND `DATE` <= :sunday");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    
    $results->execute();
    return $results; 
}
function getAllUsersforThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT * FROM `SESSIONS` WHERE `DATE` >= :monday AND `DATE` <= :sunday");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    
    $results->execute();
    return $results; 
}
function getAllSMSforThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT * FROM `SMS_MESSAGES` WHERE `DATE` >= :monday AND `DATE` <= :sunday");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    
    $results->execute();
    return $results; 
}
function getAllEmailforThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT * FROM `EMAILS` WHERE `DATE` >= :monday AND `DATE` <= :sunday");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    
    $results->execute();
    return $results; 
}
function getAllCustomersforThisWeekStartingwith($monday){
    global $conn;
    $monday = date("Y-m-d", strtotime($monday));
    $sunday = date('Y-m-d', strtotime($monday . ' +6 day'));
    $results = $conn->prepare("SELECT * FROM `CUSTOMERS` WHERE `CREATEDDATE` >= :monday AND `CREATEDDATE` <= :sunday");
    $results->bindParam(':monday', $monday);
    $results->bindParam(':sunday', $sunday);
    
    $results->execute();
    return $results; 
}