<?php
// Dashboard Route Setup
if(CheckIfPathRouteIsInTheDB('editreviews')){
    createRoute('editreviews', 'modulus/inc/reviews/views/dashboard/editreviews.php', 'dashboard');
}
if(CheckIfPathRouteIsInTheDB('createreviews')){
    createRoute('createreviews', 'modulus/inc/reviews/views/dashboard/createreviews.php', 'dashboard');
}

// Create table if Not Created
if(tableExists('REVIEWS')== false){
    createReviewTable();
}

// Create Reviews table in Database
function createReviewTable(){
    global $conn;
    $sql="  CREATE TABLE `REVIEWS` (
            `ID` int(255) NOT NULL,
            `NAME` varchar(255) NOT NULL,
            `REVIEW` varchar(1000) NOT NULL,
            `STARS` varchar(255) NOT NULL,
            `DATE` date NOT NULL,
            `ACCOUNT` varchar(255) NOT NULL,
            `IMG` varchar(255) NOT NULL,
            `STATUS` varchar(225) NOT NULL DEFAULT 'active'
            ) ENGINE=MyISAM DEFAULT CHARSET=latin1;

            ALTER TABLE `REVIEWS`
                ADD PRIMARY KEY (`ID`);
            COMMIT;

            ALTER TABLE `REVIEWS`
                MODIFY `ID` int(255) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=68;
            COMMIT;

    ";
    $results = $conn->prepare($sql);
    $results->execute();
}

// Create Review
function createReview($name, $review, $stars, $date, $account, $img, $status){
    global $conn;
    $results = $conn->prepare("INSERT INTO `REVIEWS`( `NAME`, `REVIEW`, `STARS`, `DATE`, `ACCOUNT`, `IMG`, `STATUS`) VALUES (:name ,:review ,:stars,:date,:account, :img , :status)");
    $results->bindParam(':name', $name);
    $results->bindParam(':review', $review);
    $results->bindParam(':stars', $stars);
    $results->bindParam(':status', $status);
    $results->bindParam(':date', $date);
    $results->bindParam(':account', $account);
    $results->bindParam(':img', $img);
    $results->execute();
    $last_id = $conn->lastInsertId();

    return $last_id; 
}

// Update Review
function updateReview($id, $name, $review, $stars, $date, $account, $img, $status){
    global $conn;
    $results = $conn->prepare("UPDATE `REVIEWS` SET `NAME`=:name,`REVIEW`= :review,`STARS`=:stars,`DATE`= :date,`ACCOUNT`= :account,`IMG`= :img ,`STATUS`= :status WHERE `ID`= :id");
    $results->bindParam(':name', $name);
    $results->bindParam(':review', $review);
    $results->bindParam(':stars', $stars);
    $results->bindParam(':status', $status);
    $results->bindParam(':date', $date);
    $results->bindParam(':account', $account);
    $results->bindParam(':img', $img);
    $results->bindParam(':id', $id);
    $results->execute();
    return $results; 
}

function getReviewItems(){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `REVIEWS` WHERE `STATUS` = 'active' ORDER BY `DATE` DESC");
    $results->execute();
    return $results; 

}

function getAReviewByID($id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `REVIEWS` WHERE `ID` = :id");
    $results->bindParam(':id', $id);
    $results->execute();
    return $results; 

}

function getReviewsByMonth($table, $month){
    global $conn;
    $lastdayofthemonth = date("Y-m-t", strtotime($month));
    $results = $conn->prepare("SELECT COUNT(*) FROM `".$table."` WHERE `DATE` >= '".$month."-01 00:00:00' AND `DATE` <= '".$lastdayofthemonth." 23:59:59' ");
    $results->execute();
    $count = $results->fetch(PDO::FETCH_NUM);
    return $count[0];
}

function getTotalNumberOfReviews(){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `REVIEWS`");
    $results->execute();
    return $results->rowCount();
}


