<?php
### Customers Module Setup Start ####
// Dashboard Route Setup
if(CheckIfPathRouteIsInTheDB('settings')){
    createRoute('settings', 'modulus/inc/settings/views/dashboard/settings.php', 'dashboard');
}
// Create table if Not Created
if(tableExists('SETTINGS')== false){
    createSettingsTable();
}

// Create Customers table in Database
function createSettingsTable(){
    global $conn;
    $sql="  CREATE TABLE `SETTINGS` (
            `ID` int(11) NOT NULL,
            `ORGANZATION_ID` int(11) NOT NULL,
            `DOMAIN` varchar(255) DEFAULT NULL,
            `PHONE` varchar(255) DEFAULT NULL,
            `BUSINESS_NAME` varchar(255) DEFAULT NULL,
            `EMAIL` varchar(255) DEFAULT NULL,
            `REFUND_POLICY` varchar(2550) DEFAULT NULL,
            `SENDGRID_API_KEY` varchar(255) DEFAULT NULL,
            `STRIPE_PUBLISHABLE_KEY_LIVE` varchar(255) DEFAULT NULL,
            `STRIPE_SECRET_KEY_LIVE` varchar(255) DEFAULT NULL,
            `STRIPE_PUBLISHABLE_KEY_TEST` varchar(255) DEFAULT NULL,
            `STRIPE_SECRET_KEY_TEST` varchar(255) DEFAULT NULL,
            `PAYMENT_MODE` varchar(255) DEFAULT NULL,
            `YELP_LINK` varchar(255) DEFAULT NULL,
            `FACEBOOK_LINK` varchar(255) DEFAULT NULL,
            `SECTION_REVIEWS` tinyint(1) NOT NULL DEFAULT '1',
            `SECTION_FAQS` tinyint(1) NOT NULL DEFAULT '1',
            `SECTION_CATALOG` tinyint(1) NOT NULL DEFAULT '1',
            `ALLOW_PAYMENTS` tinyint(1) NOT NULL DEFAULT '1',
            `INVOICE_PRE` varchar(255) DEFAULT NULL
            ) ENGINE=MyISAM DEFAULT CHARSET=latin1;
        
            ALTER TABLE `SETTINGS`
                ADD PRIMARY KEY (`ID`);
            
            ALTER TABLE `SETTINGS`
                MODIFY `ID` int(255) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
            COMMIT;

            INSERT INTO `SETTINGS` (`ID`, `ORGANZATION_ID`, `DOMAIN`, `BUSINESS_NAME`, `REFUND_POLICY`, `SENDGRID_API_KEY`, `STRIPE_PUBLISHABLE_KEY_LIVE`, `STRIPE_SECRET_KEY_LIVE`, `STRIPE_PUBLISHABLE_KEY_TEST`, `STRIPE_SECRET_KEY_TEST`, `PAYMENT_MODE`, `YELP_LINK`, `FACEBOOK_LINK`, `SECTION_REVIEWS`, `SECTION_FAQS`, `SECTION_CATALOG`, `ALLOW_PAYMENTS`, `INVOICE_PRE`) VALUES
            (1, 1, 'kellyrentals.org', 'Kelly Rentals', 'If you decide to cancel your rental, or weather prohibits installation we do not issue refunds for any reason but will hold your funds as a rain-check which are valid for 1 year to be used anytime you wish starting the day after your original event date. All Deposit are non refundable.', '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', 'pk_live_KFl7ZZJwSsxjpbHTOh11kKVh00M6DDvVEc', 'sk_live_2FsMmW3xCLNXBXSKkeu3DEZh00BbrUciXs', 'pk_test_1cWiaUlLAEanopBExl50vmGB00AFlnPkqk', 'sk_test_rGqXDbFWqxGS1jYlZmnwDZHP00O3OTuTF0', 'live', 'https://www.yelp.com/biz/platnium-junk-removal-irving', 'https://www.facebook.com/platinumjunk', 1, 1, 1, 1, 'KR00');
        ";
     $results = $conn->prepare($sql);
     $results->execute();
}
### Customers Module Setup End ####


# Update Customer
function updateSettings($id, $domain, $business_name, $email, $refund_policy, $sendgrid_sid, $stripe_pub_key_live, $stripe_secret_key_live, $stripe_pub_key_test,$stripe_secret_key_test, $payment_mode, $yelp_link, $facebook_link, $s_reviews, $s_faq, $s_catalog, $allow_payments, $inv_pre, $phone, $google_api_key, $sales_tax_rate, $parent_company, $sendgrid_token,$sendgrid_number, $apartment_fee ){ // 9 Varibles
    global $conn;
    $results = $conn->prepare("
    UPDATE
        `SETTINGS`
    SET
        `DOMAIN` = :domain,
        `BUSINESS_NAME` = :business_name,
        `EMAIL` = :email,
        `REFUND_POLICY` = :refund_policy,
        `SENDGRID_SID` = :sendgrid_sid,
        `SENDGRID_TOKEN` = :sendgrid_token,
        `SENDGRID_NUMBER` = :sendgrid_number,
        `STRIPE_PUBLISHABLE_KEY_LIVE` = :stripe_pub_key_live,
        `STRIPE_SECRET_KEY_LIVE` = :stripe_secret_key_live,
        `STRIPE_PUBLISHABLE_KEY_TEST` = :stripe_pub_key_test,
        `STRIPE_SECRET_KEY_TEST` = :stripe_secret_key_test,
        `PAYMENT_MODE` = :payment_mode,
        `YELP_LINK` = :yelp_link,
        `FACEBOOK_LINK` = :facebook_link,
        `SECTION_REVIEWS` = :s_reviews,
        `SECTION_FAQS` = :s_faq,
        `SECTION_CATALOG` = :s_catalog,
        `ALLOW_PAYMENTS` = :allow_payments,
        `INVOICE_PRE` = :inv_pre,
        `PHONE` = :phone,
        `GOOGLE_API_KEY` = :google_api_key,
        `PARENT_COMPANY` = :parent_company,
        `SALE_TAX_RATE` = :sales_tax_rate,
        `APARTMENT_FEE` = :apartment_fee
    WHERE
        `ID` = :id
    ");
    $results->bindParam(':id', $id);
    $results->bindParam(':domain', $domain);
    $results->bindParam(':business_name', $business_name);
    $results->bindParam(':email', $email);
    $results->bindParam(':refund_policy', $refund_policy);
    $results->bindParam(':sendgrid_sid', $sendgrid_sid);
    $results->bindParam(':sendgrid_token', $sendgrid_token);
    $results->bindParam(':sendgrid_number', $sendgrid_number);
    $results->bindParam(':stripe_pub_key_live', $stripe_pub_key_live);
    $results->bindParam(':stripe_secret_key_live', $stripe_secret_key_live);
    $results->bindParam(':stripe_pub_key_test', $stripe_pub_key_test);
    $results->bindParam(':stripe_secret_key_test', $stripe_secret_key_test);
    $results->bindParam(':payment_mode', $payment_mode);
    $results->bindParam(':yelp_link', $yelp_link);
    $results->bindParam(':facebook_link', $facebook_link);
    $results->bindParam(':s_reviews', $s_reviews);
    $results->bindParam(':s_faq', $s_faq);
    $results->bindParam(':s_catalog', $s_catalog);
    $results->bindParam(':allow_payments', $allow_payments);
    $results->bindParam(':inv_pre', $inv_pre);
    $results->bindParam(':phone', $phone);
    $results->bindParam(':google_api_key', $google_api_key);
    $results->bindParam(':sales_tax_rate', $sales_tax_rate);
    $results->bindParam(':parent_company', $parent_company);
    $results->bindParam(':apartment_fee', $apartment_fee);
    $results->execute();
    return $results;
}

function getSettings($id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `SETTINGS` WHERE `ID` = :id");
    $results->bindParam(':id', $id);
    $results->execute();
    return $results->fetch(PDO::FETCH_ASSOC); 
}


