<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Authy\V1\Service;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class EntityOptions {
    /**
     * @param string $twilioAuthySandboxMode The Twilio-Authy-Sandbox-Mode HTTP
     *                                       request header
     * @return CreateEntityOptions Options builder
     */
    public static function create(string $twilioAuthySandboxMode = Values::NONE): CreateEntityOptions {
        return new CreateEntityOptions($twilioAuthySandboxMode);
    }

    /**
     * @param string $twilioAuthySandboxMode The Twilio-Authy-Sandbox-Mode HTTP
     *                                       request header
     * @return DeleteEntityOptions Options builder
     */
    public static function delete(string $twilioAuthySandboxMode = Values::NONE): DeleteEntityOptions {
        return new DeleteEntityOptions($twilioAuthySandboxMode);
    }

    /**
     * @param string $twilioAuthySandboxMode The Twilio-Authy-Sandbox-Mode HTTP
     *                                       request header
     * @return FetchEntityOptions Options builder
     */
    public static function fetch(string $twilioAuthySandboxMode = Values::NONE): FetchEntityOptions {
        return new FetchEntityOptions($twilioAuthySandboxMode);
    }

    /**
     * @param string $twilioAuthySandboxMode The Twilio-Authy-Sandbox-Mode HTTP
     *                                       request header
     * @return ReadEntityOptions Options builder
     */
    public static function read(string $twilioAuthySandboxMode = Values::NONE): ReadEntityOptions {
        return new ReadEntityOptions($twilioAuthySandboxMode);
    }
}

class CreateEntityOptions extends Options {
    /**
     * @param string $twilioAuthySandboxMode The Twilio-Authy-Sandbox-Mode HTTP
     *                                       request header
     */
    public function __construct(string $twilioAuthySandboxMode = Values::NONE) {
        $this->options['twilioAuthySandboxMode'] = $twilioAuthySandboxMode;
    }

    /**
     * The Twilio-Authy-Sandbox-Mode HTTP request header
     *
     * @param string $twilioAuthySandboxMode The Twilio-Authy-Sandbox-Mode HTTP
     *                                       request header
     * @return $this Fluent Builder
     */
    public function setTwilioAuthySandboxMode(string $twilioAuthySandboxMode): self {
        $this->options['twilioAuthySandboxMode'] = $twilioAuthySandboxMode;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Authy.V1.CreateEntityOptions ' . $options . ']';
    }
}

class DeleteEntityOptions extends Options {
    /**
     * @param string $twilioAuthySandboxMode The Twilio-Authy-Sandbox-Mode HTTP
     *                                       request header
     */
    public function __construct(string $twilioAuthySandboxMode = Values::NONE) {
        $this->options['twilioAuthySandboxMode'] = $twilioAuthySandboxMode;
    }

    /**
     * The Twilio-Authy-Sandbox-Mode HTTP request header
     *
     * @param string $twilioAuthySandboxMode The Twilio-Authy-Sandbox-Mode HTTP
     *                                       request header
     * @return $this Fluent Builder
     */
    public function setTwilioAuthySandboxMode(string $twilioAuthySandboxMode): self {
        $this->options['twilioAuthySandboxMode'] = $twilioAuthySandboxMode;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Authy.V1.DeleteEntityOptions ' . $options . ']';
    }
}

class FetchEntityOptions extends Options {
    /**
     * @param string $twilioAuthySandboxMode The Twilio-Authy-Sandbox-Mode HTTP
     *                                       request header
     */
    public function __construct(string $twilioAuthySandboxMode = Values::NONE) {
        $this->options['twilioAuthySandboxMode'] = $twilioAuthySandboxMode;
    }

    /**
     * The Twilio-Authy-Sandbox-Mode HTTP request header
     *
     * @param string $twilioAuthySandboxMode The Twilio-Authy-Sandbox-Mode HTTP
     *                                       request header
     * @return $this Fluent Builder
     */
    public function setTwilioAuthySandboxMode(string $twilioAuthySandboxMode): self {
        $this->options['twilioAuthySandboxMode'] = $twilioAuthySandboxMode;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Authy.V1.FetchEntityOptions ' . $options . ']';
    }
}

class ReadEntityOptions extends Options {
    /**
     * @param string $twilioAuthySandboxMode The Twilio-Authy-Sandbox-Mode HTTP
     *                                       request header
     */
    public function __construct(string $twilioAuthySandboxMode = Values::NONE) {
        $this->options['twilioAuthySandboxMode'] = $twilioAuthySandboxMode;
    }

    /**
     * The Twilio-Authy-Sandbox-Mode HTTP request header
     *
     * @param string $twilioAuthySandboxMode The Twilio-Authy-Sandbox-Mode HTTP
     *                                       request header
     * @return $this Fluent Builder
     */
    public function setTwilioAuthySandboxMode(string $twilioAuthySandboxMode): self {
        $this->options['twilioAuthySandboxMode'] = $twilioAuthySandboxMode;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Authy.V1.ReadEntityOptions ' . $options . ']';
    }
}