<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Autopilot\V1\Assistant;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class ExportAssistantContext extends InstanceContext {
    /**
     * Initialize the ExportAssistantContext
     *
     * @param Version $version Version that contains the resource
     * @param string $assistantSid The SID of the Assistant to export.
     */
    public function __construct(Version $version, $assistantSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['assistantSid' => $assistantSid, ];

        $this->uri = '/Assistants/' . \rawurlencode($assistantSid) . '/Export';
    }

    /**
     * Fetch the ExportAssistantInstance
     *
     * @return ExportAssistantInstance Fetched ExportAssistantInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): ExportAssistantInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new ExportAssistantInstance($this->version, $payload, $this->solution['assistantSid']);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Autopilot.V1.ExportAssistantContext ' . \implode(' ', $context) . ']';
    }
}