<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\Rest\Conversations\V1;

/**
 * @property \Twilio\Rest\Conversations\V1 $v1
 * @property \Twilio\Rest\Conversations\V1\ConversationList $conversations
 * @property \Twilio\Rest\Conversations\V1\WebhookList $webhooks
 * @method \Twilio\Rest\Conversations\V1\ConversationContext conversations(string $sid)
 * @method \Twilio\Rest\Conversations\V1\WebhookContext webhooks()
 */
class Conversations extends Domain {
    protected $_v1;

    /**
     * Construct the Conversations Domain
     *
     * @param Client $client Client to communicate with Twilio
     */
    public function __construct(Client $client) {
        parent::__construct($client);

        $this->baseUrl = 'https://conversations.twilio.com';
    }

    /**
     * @return V1 Version v1 of conversations
     */
    protected function getV1(): V1 {
        if (!$this->_v1) {
            $this->_v1 = new V1($this);
        }
        return $this->_v1;
    }

    /**
     * Magic getter to lazy load version
     *
     * @param string $name Version to return
     * @return \Twilio\Version The requested version
     * @throws TwilioException For unknown versions
     */
    public function __get(string $name) {
        $method = 'get' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown version ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return \Twilio\InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments) {
        $method = 'context' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return \call_user_func_array([$this, $method], $arguments);
        }

        throw new TwilioException('Unknown context ' . $name);
    }

    protected function getConversations(): \Twilio\Rest\Conversations\V1\ConversationList {
        return $this->v1->conversations;
    }

    /**
     * @param string $sid A 34 character string that uniquely identifies this
     *                    resource.
     */
    protected function contextConversations(string $sid): \Twilio\Rest\Conversations\V1\ConversationContext {
        return $this->v1->conversations($sid);
    }

    protected function getWebhooks(): \Twilio\Rest\Conversations\V1\WebhookList {
        return $this->v1->webhooks;
    }

    protected function contextWebhooks(): \Twilio\Rest\Conversations\V1\WebhookContext {
        return $this->v1->webhooks();
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Conversations]';
    }
}