<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Supersim\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class FleetOptions {
    /**
     * @param string $uniqueName An application-defined string that uniquely
     *                           identifies the resource
     * @param bool $dataEnabled Defines whether SIMs in the Fleet are capable of
     *                          using data connectivity
     * @param bool $commandsEnabled Defines whether SIMs in the Fleet are capable
     *                              of sending and receiving Commands via SMS
     * @param string $commandsUrl The URL that will receive a webhook when a SIM in
     *                            the Fleet originates a machine-to-machine Command
     * @param string $commandsMethod A string representing the HTTP method to use
     *                               when making a request to `commands_url`
     * @return CreateFleetOptions Options builder
     */
    public static function create(string $uniqueName = Values::NONE, bool $dataEnabled = Values::NONE, bool $commandsEnabled = Values::NONE, string $commandsUrl = Values::NONE, string $commandsMethod = Values::NONE): CreateFleetOptions {
        return new CreateFleetOptions($uniqueName, $dataEnabled, $commandsEnabled, $commandsUrl, $commandsMethod);
    }

    /**
     * @param string $uniqueName An application-defined string that uniquely
     *                           identifies the resource
     * @return UpdateFleetOptions Options builder
     */
    public static function update(string $uniqueName = Values::NONE): UpdateFleetOptions {
        return new UpdateFleetOptions($uniqueName);
    }
}

class CreateFleetOptions extends Options {
    /**
     * @param string $uniqueName An application-defined string that uniquely
     *                           identifies the resource
     * @param bool $dataEnabled Defines whether SIMs in the Fleet are capable of
     *                          using data connectivity
     * @param bool $commandsEnabled Defines whether SIMs in the Fleet are capable
     *                              of sending and receiving Commands via SMS
     * @param string $commandsUrl The URL that will receive a webhook when a SIM in
     *                            the Fleet originates a machine-to-machine Command
     * @param string $commandsMethod A string representing the HTTP method to use
     *                               when making a request to `commands_url`
     */
    public function __construct(string $uniqueName = Values::NONE, bool $dataEnabled = Values::NONE, bool $commandsEnabled = Values::NONE, string $commandsUrl = Values::NONE, string $commandsMethod = Values::NONE) {
        $this->options['uniqueName'] = $uniqueName;
        $this->options['dataEnabled'] = $dataEnabled;
        $this->options['commandsEnabled'] = $commandsEnabled;
        $this->options['commandsUrl'] = $commandsUrl;
        $this->options['commandsMethod'] = $commandsMethod;
    }

    /**
     * An application-defined string that uniquely identifies the resource. It can be used in place of the resource's `sid` in the URL to address the resource.
     *
     * @param string $uniqueName An application-defined string that uniquely
     *                           identifies the resource
     * @return $this Fluent Builder
     */
    public function setUniqueName(string $uniqueName): self {
        $this->options['uniqueName'] = $uniqueName;
        return $this;
    }

    /**
     * Defines whether SIMs in the Fleet are capable of using 2G/3G/4G/LTE/CAT-M/NB-IoT data connectivity
     *
     * @param bool $dataEnabled Defines whether SIMs in the Fleet are capable of
     *                          using data connectivity
     * @return $this Fluent Builder
     */
    public function setDataEnabled(bool $dataEnabled): self {
        $this->options['dataEnabled'] = $dataEnabled;
        return $this;
    }

    /**
     * Defines whether SIMs in the Fleet are capable of sending and receiving Commands via SMS.
     *
     * @param bool $commandsEnabled Defines whether SIMs in the Fleet are capable
     *                              of sending and receiving Commands via SMS
     * @return $this Fluent Builder
     */
    public function setCommandsEnabled(bool $commandsEnabled): self {
        $this->options['commandsEnabled'] = $commandsEnabled;
        return $this;
    }

    /**
     * The URL that will receive a webhook when a SIM in the Fleet originates a machine-to-machine Command. Your server should respond with an HTTP status code in the 200 range; any response body will be ignored.
     *
     * @param string $commandsUrl The URL that will receive a webhook when a SIM in
     *                            the Fleet originates a machine-to-machine Command
     * @return $this Fluent Builder
     */
    public function setCommandsUrl(string $commandsUrl): self {
        $this->options['commandsUrl'] = $commandsUrl;
        return $this;
    }

    /**
     * A string representing the HTTP method to use when making a request to `commands_url`. Can be one of POST or GET. Defaults to POST.
     *
     * @param string $commandsMethod A string representing the HTTP method to use
     *                               when making a request to `commands_url`
     * @return $this Fluent Builder
     */
    public function setCommandsMethod(string $commandsMethod): self {
        $this->options['commandsMethod'] = $commandsMethod;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Supersim.V1.CreateFleetOptions ' . $options . ']';
    }
}

class UpdateFleetOptions extends Options {
    /**
     * @param string $uniqueName An application-defined string that uniquely
     *                           identifies the resource
     */
    public function __construct(string $uniqueName = Values::NONE) {
        $this->options['uniqueName'] = $uniqueName;
    }

    /**
     * An application-defined string that uniquely identifies the resource. It can be used in place of the resource's `sid` in the URL to address the resource.
     *
     * @param string $uniqueName An application-defined string that uniquely
     *                           identifies the resource
     * @return $this Fluent Builder
     */
    public function setUniqueName(string $uniqueName): self {
        $this->options['uniqueName'] = $uniqueName;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Supersim.V1.UpdateFleetOptions ' . $options . ']';
    }
}