
<?php
// Require the bundled autoload file - the path may need to change
// based on where you downloaded and unzipped the SDK
include 'inc/twilio/src/Twilio/autoload.php';

// Use the REST API Client to make requests to the Twilio REST API
use Twilio\Rest\Client;


// Your Account SID and Auth Token from twilio.com/console

function sendSMS($to, $message, $org_id){
    $settings = getSettings($org_id);
    $sid = $settings['SENDGRID_SID'];
    $token = $settings['SENDGRID_TOKEN'];
    $client = new Client($sid, $token);
    // Use the client to do fun stuff like send text messages!
    $fromNumber = $settings['SENDGRID_NUMBER'];
    $client->messages->create(
        // the number you'd like to send the message to
        $to,
        [
            // A Twilio phone number you purchased at twilio.com/console
            'from' => $fromNumber,
            // the body of the text message you'd like to send
            'body' => $message
        ]
    );
}
