<!doctype html>
<?php

### Defualt Functions Varibles
$orderDetailspre = getProjectDetail($_GET['orderid']);
$orderDetails = $orderDetailspre->fetch(PDO::FETCH_ASSOC);

$customerDetailsPre = getCustomerDetail($orderDetails['CUSTOMER_ID']);
$customerDetails = $customerDetailsPre->fetch(PDO::FETCH_ASSOC);

$getProjectItemsPre = getProjectItems($orderDetails['ID']);
// $getProjectItems = $getProjectItemsPre->fetch(PDO::FETCH_ASSOC);

// Distance Irving Address - 001
$destination =   str_replace(" ", "+", $orderDetails['DELIVERY_ADDRESS']) ;

if($orderDetails['PAYMENT'] == "Full"){
    $paymentstatuscolor = "green";
}elseif($orderDetails['PAYMENT'] == "Partial"){
    $paymentstatuscolor = "orange";
}else{
    $paymentstatuscolor = "red";
}

$settings = getSettings(1);
?>

<html lang="en">
    <head>
        <title>Event & Party Rental | Chairs & Table Rental</title>
        <meta name="description" content="Looking for affordable chairs & table rentals in the DFW we can Help. Book Today. Get free delivery on all orders over $50 dollars.">
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/lib/bootstrap/css/bootstrap.min.css" >

        <!-- Font Awesome -->
        <link rel="stylesheet" href="assets/lib/fontawesome/css/all.css" >

        <!-- Custom Styling Sheet-->
        <link rel="stylesheet" href="assets/css/style.css" >

        <!-- Google Font-->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto+Slab|Tangerine&display=swap">

        <!-- Global site tag (gtag.js) - Google Ads: 691283663 -->
            <script async src="https://www.googletagmanager.com/gtag/js?id=AW-691283663"></script>
            <script>
              window.dataLayer = window.dataLayer || [];
              function gtag(){dataLayer.push(arguments);}
              gtag('js', new Date());
            
              gtag('config', 'AW-691283663');
            </script>

            
        <!-- Bing Ads UET Tag -->
            <script>(function(w,d,t,r,u){var f,n,i;w[u]=w[u]||[],f=function(){var o={ti:"137020671"};o.q=w[u],w[u]=new UET(o),w[u].push("pageLoad")},n=d.createElement(t),n.src=r,n.async=1,n.onload=n.onreadystatechange=function(){var s=this.readyState;s&&s!=="loaded"&&s!=="complete"||(f(),n.onload=n.onreadystatechange=null)},i=d.getElementsByTagName(t)[0],i.parentNode.insertBefore(n,i)})(window,document,"script","//bat.bing.com/bat.js","uetq");</script>
       

        <style>
        .tangerine{
            font-family: 'Tangerine', cursive;
        }
        .robotoslab{
            font-family: 'Roboto Slab', serif;
        }
        .stripe-button-el{
            display: none !important;
        }
        </style>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
        <script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=<?php echo $settings['GOOGLE_API_KEY']; ?>&libraries=places"></script>

        <script>

            var searchInput = 'search_input';

            $(document).ready(function () {
                var autocomplete;
                autocomplete = new google.maps.places.Autocomplete((document.getElementById(searchInput)), {
                    types: ['geocode'],
                });
                
            });

            var autocomplete;
            autocomplete = new google.maps.places.Autocomplete((document.getElementById(searchInput)), {
                types: ['geocode'],
                componentRestrictions: {
                    country: "USA"
                }
            });
        </script>
        
    </head>
    <body>
        <header>
            <nav class="navbar navbar-expand-lg white-bg navbar-light fixed-top">
                <div class="container">
                    <a class="navbar-brand tangerine" href="/"><?php echo $settings['BUSINESS_NAME'];?></a>
                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarTogglerDemo03" aria-controls="navbarTogglerDemo03" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                    </button>
                
                    <div class="collapse navbar-collapse robotoslab" id="navbarTogglerDemo03">
                        <ul class="navbar-nav ml-auto">
                            <li class="nav-item">
                                <a class="nav-link" title="View Our Rates" href="#eventdetails">Event</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" title="Get A Quick Quote" href="#items">Items</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" title="Read Our Reviews" href="#payment">Payment</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" title="Call Or Text Us NOW" href="tel:<?php echo $settings['PHONE'];?>"><i class="fa fa-phone"></i></a>
                            </li>
                        </ul>
                    </div>
                </div>
              </nav>
        </header>
        <section id="maps" style="margin-bottom:40px; margin-top:80px">
            <div class="container">
                <div class=" row">
                    <?php if( isset($_GET['success']) ){?>
                        <div class="alert alert-success col-12 text-center " role="alert" style="font-size:14px;">
                            Thank you so much <?php echo $customerDetails['NAME']; ?>! Your payment was succesful.
                        </div>
                    <?php } ?>
                    <?php if( isset($_GET['error']) ){?>
                        <div class="alert alert-danger col-12 text-center" role="alert" style="font-size:14px;">
                            Sorry <?php echo $customerDetails['NAME']; ?>! Your payment has failed.
                        </div>
                    <?php } ?>
                    <div class=" card col-12 col-md-9 col-lg-9 pl-0 pr-0">
                        <img width="100%" height="400px" src="https://maps.googleapis.com/maps/api/staticmap?center=<?php echo $destination;?>&zoom=13&size=600x300&maptype=roadmap&mobile=true&key=<?php echo $settings['GOOGLE_API_KEY']; ?>">
                    </div>
                    <div class="card col-12 col-md-3 col-lg-3 pl-0 pr-0" style="border-radius:0">
                        <h5 class="card-header">Customer Details</h5>
                        <div class="card-body row">
                            <div class="col-12">
                                <p class="card-text"><h5><?php echo $customerDetails['NAME']; ?></h5></p>
                                <p class="card-text"><h6><?php echo $customerDetails['COMPANY'];  ?></h6></p>
                                <p class="card-text"><?php echo phone_number_format($customerDetails['PHONE']); ?></p>
                                <p class="card-text"><?php echo $customerDetails['EMAIL']; ?></p>
                                <p class="card-text"><?php echo $orderDetails['DELIVERY_ADDRESS']; ?></p>
                                <p class="card-text">Estimate #: <b><?php echo $settings['INVOICE_PRE']; ?><?php echo $orderDetails['ID']; ?></b></p>
                                <p class="card-text">Payment Status: <b style="color:<?php echo $paymentstatuscolor; ?>;"><?php echo $orderDetails['PAYMENT']; ?></b></p>
                            </div>
                        </div>
                    </div>
                </div>
            <div>
        </section>
        <section id="eventdetails">
            <div class="container">
                <div class="row" >
                    <div class="card col-12 pl-0 pr-0" style="border-radius:0;margin-bottom:40px; ">
                        <h5 class="card-header">Event Details</h5>
                        <div class="card-body row">
                            <div class="col-sm-6 col-md-6 col-lg-6 col-12">
                                <?php $dateDD = date_create($orderDetails['DELIVERY_DATE']);?>
                                <?php $datePD = date_create($orderDetails['PICKUP_DATE']);?>
                                <?php $dateDTS = date_create($orderDetails['DELIVERY_TIME_START']);?>
                                <?php $datePTS = date_create($orderDetails['PICKUP_TIME_START']);?>
                                <?php $datePTE = date_create($orderDetails['PICKUP_TIME_END']);?>
                                
                                <p class="card-text"><b>Delivery Date:</b> <?php echo date_format($dateDD ,"l, F jS, Y"); ?></p>
                                <p class="card-text"><b>Delivery Start Time:</b>  <?php echo date_format($dateDTS,"g A" ); ?></p>
                                <p class="card-text"><b>Delivery End Time:</b>  <?php echo date_format(date_create($orderDetails['EVENT_START_TIME']),"g A" ); ?></p>
                                <p class="card-text"><b>Delivery Address:</b>  <?php echo $orderDetails['DELIVERY_ADDRESS']; ?></p>
                                <p class="card-text"><b>Building Type:</b>  <?php echo $orderDetails['BUILDING_TYPE']; ?></p>
                            </div>
                            <div class="col-sm-6 col-md-6 col-lg-6 col-12">
                                <p class="card-text"><b>Pickup Date:</b> <?php echo date_format($datePD ,"l, F jS, Y"); ?></p>
                                <p class="card-text"><b>Pickup Start Time:</b>  <?php echo date_format($datePTS,"g A" ); ?></p>
                                <p class="card-text"><b>Pickup End Time:</b>  <?php echo date_format($datePTE,"g A" ); ?></p>
                                <p class="card-text"><b>Pickup Address:</b>  <?php echo $orderDetails['PICKUP_ADDRESS']; ?></p>
                                <p class="card-text"><b>Event Type:</b>  <?php echo $orderDetails['TYPE']; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section id="items">
            <div class="container">
                <div class="row">
                    <div class="card col-12 pl-0 pr-0" style="border-radius:0; margin-bottom:40px;"> 
                        <h5 class="card-header">Rental Items</h5>
                        <?php include 'views/pages/dashboard/parts/orderitems.php'; ?>
                    </div>
                    <div class="card col-12 pl-0 pr-0" style="border-radius:0; margin-bottom:40px;">
                        <h5 class="card-header">Cancellation Policy</h5>
                        <div class="card-body">
                            <?php echo $settings['REFUND_POLICY']; ?>
                        </div>
                    </div>
                    <?php if($orderDetails['PAYMENT'] !="Full" && $showpayment == true){ ?>
                    <div class="col-12 robotoslab cta p-0 text-center" style="margin-top: 0; margin-bottom:40px;" id="payment">
                        <form action="modulus/stripe.php?type=stripe&org_id=<?php echo $orderDetails['ORGANIZATION_ID']; ?>&paymentstatus=<?php echo $paymentstatus?>&price=<?php echo str_replace(',', '',str_replace('.', '', $deposit)); ?>&orderdetails_id=<?php echo $orderDetails['ID']; ?>&customeremail=<?php echo $customerDetails['EMAIL'] ; ?>&customername=<?php echo $customerDetails['NAME'] ; ?>" method="POST">
                            <script
                                src="https://checkout.stripe.com/checkout.js" class="stripe-button"
                                data-key="<?php if($settings['PAYMENT_MODE'] =='live'){echo $settings['STRIPE_PUBLISHABLE_KEY_LIVE'];}else{echo $settings['STRIPE_PUBLISHABLE_KEY_TEST'];}?>"
                                data-amount="<?php echo str_replace(',', '',str_replace('.', '',$deposit)); ?>"
                                data-name="<?php echo $settings['BUSINESS_NAME'];?>"
                                data-description="Estimate <?php echo $settings['INVOICE_PRE']; ?><?php echo $orderDetails['ID']; ?>"
                                data-image="<?php echo $settings['DOMAIN'];?>/assets/img/logo.jpeg"
                                data-locale="auto"
                                data-zip-code="true">
                            </script>
                            <button type="submit" style="border-radius:0;padding:25px; margin: 0px 0 10px !important;" class="btn btn-block navybg robotoslab">Make Payment</button>
                        </form>
                        <!-- <a href="#Quote">Talk to a Specialist</a> -->
                    </div>
                    <?php } ?>
                </div>
            </div>
            
        </section>
<!-- Import Footer -->
<?php include 'views/parts/footer.php'; ?>